IF OBJECT_ID('EST_PROD_PRECO_PESQ_MERC_ANALISE') IS NULL 
BEGIN
CREATE TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE](
	[CD_EMP] [int] NOT NULL,
	[CD_PESQ] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[MEDIAF] [money] NOT NULL,
	[VLR_CUSTO] [money] NOT NULL,
	[VLR_OFERTA] [money] NOT NULL,
	[VLR_TABELA] [money] NOT NULL,
	[CD_EMP_MENOR_PRECO] [int] NOT NULL,
	[DS_EMP_MENOR_PRECO] [varchar](100) NOT NULL,
	[TP_EMP_MENOR_PRECO] [int] NOT NULL,
	[VLR_MENOR_PRECO] [money] NOT NULL,
	[VLR_MARGEM_MENOR_PRECO] [money] NOT NULL,
	[PERC_MARGEM_MENOR_PRECO] [money] NOT NULL,
	[CD_EMP_MAIOR_PRECO] [int] NOT NULL,
	[DS_EMP_MAIOR_PRECO] [varchar](100) NOT NULL,
	[TP_EMP_MAIOR_PRECO] [int] NOT NULL,
	[VLR_MAIOR_PRECO] [money] NOT NULL,
	[VLR_MARGEM_MAIOR_PRECO] [money] NOT NULL,
	[PERC_MARGEM_MAIOR_PRECO] [money] NOT NULL,
	[VLR_MEDIO] [money] NOT NULL,
	[VLR_MEDIANA] [money] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NULL,
	[DT_ULT_ALT] [datetime] NULL,
 CONSTRAINT [PK_EST_PROD_PRECO_PESQ_MERC_ANALISE] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_PESQ] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 85) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_ANALISE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_ANALISE_CD_PESQ]  DEFAULT ((0)) FOR [CD_PESQ]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_ANALISE_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_ANALISE_MEDIAF]  DEFAULT ((0)) FOR [MEDIAF]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_ANALISE_VLR_CUSTO]  DEFAULT ((0)) FOR [VLR_CUSTO]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_ANALISE_VLR_OFERTA]  DEFAULT ((0)) FOR [VLR_OFERTA]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_ANALISE_VLR_TABELA]  DEFAULT ((0)) FOR [VLR_TABELA]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_ANALISE_CD_USU]  DEFAULT ((1)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_ANALISE_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] CHECK CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_ANALISE_EST_PROD]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_ANALISE_EST_PROD_PRECO_PESQ] FOREIGN KEY([CD_EMP], [CD_PESQ])
REFERENCES [dbo].[EST_PROD_PRECO_PESQ_MERC] ([CD_EMP], [CD_PESQ])

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_ANALISE] CHECK CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_ANALISE_EST_PROD_PRECO_PESQ]
end